<?xml version="1.0" encoding="UTF-8"?>
<!-- Examination Review Stylesheet
     Show all questions with their answers and explanations
     Written by Keith Wood, 16 June, 2000 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- The overall document -->
  <xsl:template match="/">
    <html>
    <head>
    <title><xsl:value-of select="exam/title"/> Review</title>
    </head>
    <body>
    <xsl:apply-templates select="exam"/>
    <hr/>
    <p>Written by <a href="mailto:kbwood@iprimus.com.au">Keith Wood</a>.</p>
    </body>
    </html>
  </xsl:template>

  <!-- Display exam name, description, and instructions -->
  <xsl:template match="exam">
    <h1><a name="top"></a><xsl:value-of select="title"/> Review</h1>
    <p><strong>Description:</strong>&#160;<xsl:value-of select="description"/></p>
    <p>This test has a pass mark of
    <strong><xsl:value-of select="@pass_mark"/>%</strong>.</p>
    <p><xsl:choose>
      <xsl:when test="self::node()[@strict_order='true']">Questions are asked in the <strong>order shown</strong>.</xsl:when>
      <xsl:otherwise>Questions are asked in <strong>random order</strong>.</xsl:otherwise>
      </xsl:choose>
    </p>
    <p><strong>Instructions:</strong>&#160;<xsl:value-of select="instructions"/></p>
    <hr/>
    <ul>
      <xsl:apply-templates select="question" mode="list"/>
    </ul>
    <table border="0" width="100%">
      <xsl:apply-templates select="question" mode="detail"/>
    </table>
  </xsl:template>

  <!-- Display links to the questions -->
  <xsl:template match="question" mode="list">
    <li><a href="#{@id}">Question <xsl:value-of select="@id"/></a></li>
  </xsl:template>

  <!-- Display each question, with its query, answers, and any explanation -->
  <xsl:template match="question" mode="detail">
    <tr><td colspan="2">
      <hr/>
      <h2><a name="{@id}">Question <xsl:value-of select="@id"/></a></h2></td>
    </tr>
    <tr><th align="right" valign="top">Query:</th>
      <td><pre><xsl:value-of select="query"/></pre></td>
    </tr>
    <tr><th align="right" valign="top">Answer(s):</th>
      <td><xsl:apply-templates select="answers"/></td>
    </tr>
    <tr><th align="right" valign="top">Explanation:</th>
      <td><p><xsl:value-of select="explanation"/></p></td>
    </tr>
    <tr><td></td><td><a href="#top">Back to the top</a></td></tr>
  </xsl:template>

  <!-- Format answers for radio button/checkbox type responses -->
  <xsl:template match="answers[@type!='text']/answer">
    <input type="{../@type}" readonly="true">
      <xsl:if test="self::node()[@correct='true']">
        <xsl:attribute name="checked">Y</xsl:attribute>
      </xsl:if>
    </input>
    <xsl:value-of select="."/><br/>
  </xsl:template>

  <!-- Format answers for text type responses -->
  <xsl:template match="answers[@type='text']">
    <input type="text" readonly="true"/><br/>
    <p>Valid answers:
      <xsl:apply-templates select="answer"/>
    </p>
  </xsl:template>

  <!-- Format answers for text type responses -->
  <xsl:template match="answers[@type='text']/answer">
    <xsl:value-of select="."/><xsl:if test="position()!=last()">,</xsl:if>
  </xsl:template>
</xsl:stylesheet>
